/***************************** LICENSE START ***********************************

Copyright 2012 ECMWF and INPE. This software is distributed under the terms
of the Apache License version 2.0. In applying this license, ECMWF does not
waive the privileges and immunities granted to it by virtue of its status as
an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

#include <QStringList>
#include <QHash>

class BufrFlatDataItem
{
public:
    BufrFlatDataItem(BufrFlatDataItem* parent = nullptr);
    virtual ~BufrFlatDataItem();

    BufrFlatDataItem* childAt(int row);
    BufrFlatDataItem* parent() const { return parent_; }
    int childCount() const;
    int indexInParent() const;

    virtual QString title(int) const { return {}; }
    QString data(QString key) const;
    QString key() const;
    QString value(int subset = -1) const { return getValue(subset, true); }
    QString rawValue(int subset = -1) const { return getValue(subset, false); }
    QString getValue(int subset, bool includeCount) const;
    QStringList valueArray() const { return valueArray_; }
    bool valueIsArray() const { return !valueArray_.isEmpty(); }

    virtual bool isGroup() const { return false; }

    static BufrFlatDataItem* loadDump(const std::string&, QString& err);
    static BufrFlatDataItem* addItem(const std::string& key, const std::string& value, bool isArrayValue,
                                     BufrFlatDataItem* parent, bool);
    static BufrFlatDataItem* addSubsetItem(const std::string& key, const std::string& value, BufrFlatDataItem* parent);

protected:
    void addChild(BufrFlatDataItem* item);
    static  QStringList parseArray(QString);
    static QString beautify(QStringList arrayVal, bool);

    QString key_;
    QString value_;
    QStringList valueArray_;

    QList<BufrFlatDataItem*> children_;
    BufrFlatDataItem* parent_;
};

class BufrFlatDataGroupItem : public BufrFlatDataItem
{
    friend class BufrFlatDataItem;

public:
    BufrFlatDataGroupItem(BufrFlatDataItem* parent = nullptr) :
        BufrFlatDataItem(parent) {}

    bool isGroup() const override { return true; }
    QString title(int subset = -1) const override;

protected:
    QString title_;
};
