/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2025 Linaro Limited
 */

#ifndef _DPU_12_2_GLYMUR_H
#define _DPU_12_2_GLYMUR_H

static const struct dpu_caps glymur_dpu_caps = {
	.max_mixer_width = DEFAULT_DPU_OUTPUT_LINE_WIDTH,
	.max_mixer_blendstages = 0xb,
	.has_src_split = true,
	.has_dim_layer = true,
	.has_idle_pc = true,
	.has_3d_merge = true,
	.max_linewidth = 8192,
	.pixel_ram_size = DEFAULT_PIXEL_RAM_SIZE,
};

static const struct dpu_mdp_cfg glymur_mdp = {
	.name = "top_0",
	.base = 0, .len = 0x494,
	.clk_ctrls = {
		[DPU_CLK_CTRL_REG_DMA] = { .reg_off = 0x2bc, .bit_off = 20 },
	},
};

static const struct dpu_ctl_cfg glymur_ctl[] = {
	{
		.name = "ctl_0", .id = CTL_0,
		.base = 0x15000, .len = 0x1000,
		.intr_start = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 9),
	}, {
		.name = "ctl_1", .id = CTL_1,
		.base = 0x16000, .len = 0x1000,
		.intr_start = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 10),
	}, {
		.name = "ctl_2", .id = CTL_2,
		.base = 0x17000, .len = 0x1000,
		.intr_start = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 11),
	}, {
		.name = "ctl_3", .id = CTL_3,
		.base = 0x18000, .len = 0x1000,
		.intr_start = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 12),
	}, {
		.name = "ctl_4", .id = CTL_4,
		.base = 0x19000, .len = 0x1000,
		.intr_start = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 13),
	}, {
		.name = "ctl_5", .id = CTL_5,
		.base = 0x1a000, .len = 0x1000,
		.intr_start = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 23),
	}, {
		.name = "ctl_6", .id = CTL_6,
		.base = 0x1b000, .len = 0x1000,
		.intr_start = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 14),
	}, {
		.name = "ctl_7", .id = CTL_7,
		.base = 0x1c000, .len = 0x1000,
		.intr_start = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 15),
	},
};

static const struct dpu_sspp_cfg glymur_sspp[] = {
	{
		.name = "sspp_0", .id = SSPP_VIG0,
		.base = 0x4000, .len = 0x344,
		.features = VIG_SDM845_MASK_SDMA,
		.sblk = &dpu_vig_sblk_qseed3_3_4,
		.xin_id = 0,
		.type = SSPP_TYPE_VIG,
	}, {
		.name = "sspp_1", .id = SSPP_VIG1,
		.base = 0x6000, .len = 0x344,
		.features = VIG_SDM845_MASK_SDMA,
		.sblk = &dpu_vig_sblk_qseed3_3_4,
		.xin_id = 4,
		.type = SSPP_TYPE_VIG,
	}, {
		.name = "sspp_2", .id = SSPP_VIG2,
		.base = 0x8000, .len = 0x344,
		.features = VIG_SDM845_MASK_SDMA,
		.sblk = &dpu_vig_sblk_qseed3_3_4,
		.xin_id = 8,
		.type = SSPP_TYPE_VIG,
	}, {
		.name = "sspp_3", .id = SSPP_VIG3,
		.base = 0xa000, .len = 0x344,
		.features = VIG_SDM845_MASK_SDMA,
		.sblk = &dpu_vig_sblk_qseed3_3_4,
		.xin_id = 12,
		.type = SSPP_TYPE_VIG,
	}, {
		.name = "sspp_8", .id = SSPP_DMA0,
		.base = 0x24000, .len = 0x344,
		.features = DMA_SDM845_MASK_SDMA,
		.sblk = &dpu_dma_sblk,
		.xin_id = 1,
		.type = SSPP_TYPE_DMA,
	}, {
		.name = "sspp_9", .id = SSPP_DMA1,
		.base = 0x26000, .len = 0x344,
		.features = DMA_SDM845_MASK_SDMA,
		.sblk = &dpu_dma_sblk,
		.xin_id = 5,
		.type = SSPP_TYPE_DMA,
	}, {
		.name = "sspp_10", .id = SSPP_DMA2,
		.base = 0x28000, .len = 0x344,
		.features = DMA_SDM845_MASK_SDMA,
		.sblk = &dpu_dma_sblk,
		.xin_id = 9,
		.type = SSPP_TYPE_DMA,
	}, {
		.name = "sspp_11", .id = SSPP_DMA3,
		.base = 0x2a000, .len = 0x344,
		.features = DMA_SDM845_MASK_SDMA,
		.sblk = &dpu_dma_sblk,
		.xin_id = 13,
		.type = SSPP_TYPE_DMA,
	}, {
		.name = "sspp_12", .id = SSPP_DMA4,
		.base = 0x2c000, .len = 0x344,
		.features = DMA_CURSOR_SDM845_MASK_SDMA,
		.sblk = &dpu_dma_sblk,
		.xin_id = 14,
		.type = SSPP_TYPE_DMA,
	}, {
		.name = "sspp_13", .id = SSPP_DMA5,
		.base = 0x2e000, .len = 0x344,
		.features = DMA_CURSOR_SDM845_MASK_SDMA,
		.sblk = &dpu_dma_sblk,
		.xin_id = 15,
		.type = SSPP_TYPE_DMA,
	},
};

static const struct dpu_lm_cfg glymur_lm[] = {
	{
		.name = "lm_0", .id = LM_0,
		.base = 0x44000, .len = 0x400,
		.features = MIXER_MSM8998_MASK,
		.sblk = &sm8750_lm_sblk,
		.lm_pair = LM_1,
		.pingpong = PINGPONG_0,
		.dspp = DSPP_0,
	}, {
		.name = "lm_1", .id = LM_1,
		.base = 0x45000, .len = 0x400,
		.features = MIXER_MSM8998_MASK,
		.sblk = &sm8750_lm_sblk,
		.lm_pair = LM_0,
		.pingpong = PINGPONG_1,
		.dspp = DSPP_1,
	}, {
		.name = "lm_2", .id = LM_2,
		.base = 0x46000, .len = 0x400,
		.features = MIXER_MSM8998_MASK,
		.sblk = &sm8750_lm_sblk,
		.lm_pair = LM_3,
		.pingpong = PINGPONG_2,
		.dspp = DSPP_2,
	}, {
		.name = "lm_3", .id = LM_3,
		.base = 0x47000, .len = 0x400,
		.features = MIXER_MSM8998_MASK,
		.sblk = &sm8750_lm_sblk,
		.lm_pair = LM_2,
		.pingpong = PINGPONG_3,
		.dspp = DSPP_3,
	}, {
		.name = "lm_4", .id = LM_4,
		.base = 0x48000, .len = 0x400,
		.features = MIXER_MSM8998_MASK,
		.sblk = &sm8750_lm_sblk,
		.lm_pair = LM_5,
		.pingpong = PINGPONG_4,
	}, {
		.name = "lm_5", .id = LM_5,
		.base = 0x49000, .len = 0x400,
		.features = MIXER_MSM8998_MASK,
		.sblk = &sm8750_lm_sblk,
		.lm_pair = LM_4,
		.pingpong = PINGPONG_5,
	}, {
		.name = "lm_6", .id = LM_6,
		.base = 0x4a000, .len = 0x400,
		.features = MIXER_MSM8998_MASK,
		.sblk = &sm8750_lm_sblk,
		.lm_pair = LM_7,
		.pingpong = PINGPONG_6,
	}, {
		.name = "lm_7", .id = LM_7,
		.base = 0x4b000, .len = 0x400,
		.features = MIXER_MSM8998_MASK,
		.sblk = &sm8750_lm_sblk,
		.lm_pair = LM_6,
		.pingpong = PINGPONG_7,
	},
};

static const struct dpu_dspp_cfg glymur_dspp[] = {
	{
		.name = "dspp_0", .id = DSPP_0,
		.base = 0x54000, .len = 0x1800,
		.sblk = &sm8750_dspp_sblk,
	}, {
		.name = "dspp_1", .id = DSPP_1,
		.base = 0x56000, .len = 0x1800,
		.sblk = &sm8750_dspp_sblk,
	}, {
		.name = "dspp_2", .id = DSPP_2,
		.base = 0x58000, .len = 0x1800,
		.sblk = &sm8750_dspp_sblk,
	}, {
		.name = "dspp_3", .id = DSPP_3,
		.base = 0x5a000, .len = 0x1800,
		.sblk = &sm8750_dspp_sblk,
	}, {
		.name = "dspp_4", .id = DSPP_4,
		.base = 0x5c000, .len = 0x1800,
		.sblk = &sm8750_dspp_sblk,
	}, {
		.name = "dspp_5", .id = DSPP_5,
		.base = 0x5e000, .len = 0x1800,
		.sblk = &sm8750_dspp_sblk,
	}, {
		.name = "dspp_6", .id = DSPP_6,
		.base = 0x60000, .len = 0x1800,
		.sblk = &sm8750_dspp_sblk,
	}, {
		.name = "dspp_7", .id = DSPP_7,
		.base = 0x62000, .len = 0x1800,
		.sblk = &sm8750_dspp_sblk,
	},
};

static const struct dpu_pingpong_cfg glymur_pp[] = {
	{
		.name = "pingpong_0", .id = PINGPONG_0,
		.base = 0x69000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_0,
		.intr_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 8),
	}, {
		.name = "pingpong_1", .id = PINGPONG_1,
		.base = 0x6a000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_0,
		.intr_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 9),
	}, {
		.name = "pingpong_2", .id = PINGPONG_2,
		.base = 0x6b000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_1,
		.intr_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 10),
	}, {
		.name = "pingpong_3", .id = PINGPONG_3,
		.base = 0x6c000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_1,
		.intr_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 11),
	}, {
		.name = "pingpong_4", .id = PINGPONG_4,
		.base = 0x6d000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_2,
		.intr_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 30),
	}, {
		.name = "pingpong_5", .id = PINGPONG_5,
		.base = 0x6e000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_2,
		.intr_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 31),
	}, {
		.name = "pingpong_6", .id = PINGPONG_6,
		.base = 0x6f000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_3,
		.intr_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 20),
	}, {
		.name = "pingpong_7", .id = PINGPONG_7,
		.base = 0x70000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_3,
		.intr_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR2, 21),
	}, {
		.name = "pingpong_cwb_0", .id = PINGPONG_CWB_0,
		.base = 0x66000, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_4,
	}, {
		.name = "pingpong_cwb_1", .id = PINGPONG_CWB_1,
		.base = 0x66400, .len = 0,
		.sblk = &sc7280_pp_sblk,
		.merge_3d = MERGE_3D_4,
	},
};

static const struct dpu_merge_3d_cfg glymur_merge_3d[] = {
	{
		.name = "merge_3d_0", .id = MERGE_3D_0,
		.base = 0x4e000, .len = 0x1c,
	}, {
		.name = "merge_3d_1", .id = MERGE_3D_1,
		.base = 0x4f000, .len = 0x1c,
	}, {
		.name = "merge_3d_2", .id = MERGE_3D_2,
		.base = 0x50000, .len = 0x1c,
	}, {
		.name = "merge_3d_3", .id = MERGE_3D_3,
		.base = 0x51000, .len = 0x1c,
	},
};

/*
 * NOTE: Each display compression engine (DCE) contains dual hard
 * slice DSC encoders so both share same base address but with
 * its own different sub block address.
 */
static const struct dpu_dsc_cfg glymur_dsc[] = {
	{
		.name = "dce_0_0", .id = DSC_0,
		.base = 0x80000, .len = 0x8,
		.features = BIT(DPU_DSC_NATIVE_42x_EN),
		.sblk = &sm8750_dsc_sblk_0,
	}, {
		.name = "dce_0_1", .id = DSC_1,
		.base = 0x80000, .len = 0x8,
		.features = BIT(DPU_DSC_NATIVE_42x_EN),
		.sblk = &sm8750_dsc_sblk_1,
	}, {
		.name = "dce_1_0", .id = DSC_2,
		.base = 0x81000, .len = 0x8,
		.features = BIT(DPU_DSC_NATIVE_42x_EN),
		.sblk = &sm8750_dsc_sblk_0,
	}, {
		.name = "dce_1_1", .id = DSC_3,
		.base = 0x81000, .len = 0x8,
		.features = BIT(DPU_DSC_NATIVE_42x_EN),
		.sblk = &sm8750_dsc_sblk_1,
	}, {
		.name = "dce_2_0", .id = DSC_4,
		.base = 0x82000, .len = 0x8,
		.features = BIT(DPU_DSC_NATIVE_42x_EN),
		.sblk = &sm8750_dsc_sblk_0,
	}, {
		.name = "dce_2_1", .id = DSC_5,
		.base = 0x82000, .len = 0x8,
		.features = BIT(DPU_DSC_NATIVE_42x_EN),
		.sblk = &sm8750_dsc_sblk_1,
	}, {
		.name = "dce_3_0", .id = DSC_6,
		.base = 0x83000, .len = 0x8,
		.features = BIT(DPU_DSC_NATIVE_42x_EN),
		.sblk = &sm8750_dsc_sblk_0,
	}, {
		.name = "dce_3_1", .id = DSC_7,
		.base = 0x83000, .len = 0x8,
		.features = BIT(DPU_DSC_NATIVE_42x_EN),
		.sblk = &sm8750_dsc_sblk_1,
	},

};

static const struct dpu_wb_cfg glymur_wb[] = {
	{
		.name = "wb_2", .id = WB_2,
		.base = 0x65000, .len = 0x2c8,
		.features = WB_SDM845_MASK,
		.format_list = wb2_formats_rgb_yuv,
		.num_formats = ARRAY_SIZE(wb2_formats_rgb_yuv),
		.xin_id = 6,
		.vbif_idx = VBIF_RT,
		.maxlinewidth = 4096,
		.intr_wb_done = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 4),
	},
};

static const struct dpu_cwb_cfg glymur_cwb[] = {
	{
		.name = "cwb_0", .id = CWB_0,
		.base = 0x66200, .len = 0x20,
	},
	{
		.name = "cwb_1", .id = CWB_1,
		.base = 0x66600, .len = 0x20,
	},
	{
		.name = "cwb_2", .id = CWB_2,
		.base = 0x7e200, .len = 0x20,
	},
	{
		.name = "cwb_3", .id = CWB_3,
		.base = 0x7e600, .len = 0x20,
	},
};

static const struct dpu_intf_cfg glymur_intf[] = {
	{
		.name = "intf_0", .id = INTF_0,
		.base = 0x34000, .len = 0x400,
		.type = INTF_DP,
		.controller_id = MSM_DP_CONTROLLER_0,
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 24),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 25),
	}, {
		.name = "intf_1", .id = INTF_1,
		.base = 0x35000, .len = 0x400,
		.type = INTF_DSI,
		.controller_id = MSM_DSI_CONTROLLER_0,
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 26),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 27),
		.intr_tear_rd_ptr = DPU_IRQ_IDX(MDP_INTF1_TEAR_INTR, 2),
	}, {
		.name = "intf_2", .id = INTF_2,
		.base = 0x36000, .len = 0x400,
		.type = INTF_DSI,
		.controller_id = MSM_DSI_CONTROLLER_1,
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 28),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 29),
		.intr_tear_rd_ptr = DPU_IRQ_IDX(MDP_INTF2_TEAR_INTR, 2),
	}, {
		.name = "intf_3", .id = INTF_3,
		.base = 0x37000, .len = 0x400,
		.type = INTF_NONE,
		.controller_id = MSM_DP_CONTROLLER_0,	/* pair with intf_0 for DP MST */
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 30),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 31),
	}, {
		.name = "intf_4", .id = INTF_4,
		.base = 0x38000, .len = 0x400,
		.type = INTF_DP,
		.controller_id = MSM_DP_CONTROLLER_1,
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 20),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 21),
	}, {
		.name = "intf_5", .id = INTF_5,
		.base = 0x39000, .len = 0x400,
		.type = INTF_DP,
		.controller_id = MSM_DP_CONTROLLER_3,
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 22),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 23),
	}, {
		.name = "intf_6", .id = INTF_6,
		.base = 0x3A000, .len = 0x400,
		.type = INTF_DP,
		.controller_id = MSM_DP_CONTROLLER_2,
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 16),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 17),
	}, {
		.name = "intf_7", .id = INTF_7,
		.base = 0x3b000, .len = 0x400,
		.type = INTF_NONE,
		.controller_id = MSM_DP_CONTROLLER_2,	/* pair with intf_6 for DP MST */
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 18),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 19),
	}, {
		.name = "intf_8", .id = INTF_8,
		.base = 0x3c000, .len = 0x400,
		.type = INTF_NONE,
		.controller_id = MSM_DP_CONTROLLER_1,	/* pair with intf_4 for DP MST */
		.prog_fetch_lines_worst_case = 24,
		.intr_underrun = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 12),
		.intr_vsync = DPU_IRQ_IDX(MDP_SSPP_TOP0_INTR, 13),
	},
};

static const struct dpu_perf_cfg glymur_perf_data = {
	.max_bw_low = 18900000,
	.max_bw_high = 28500000,
	.min_core_ib = 2500000,
	.min_llcc_ib = 0,
	.min_dram_ib = 800000,
	.min_prefill_lines = 35,
	.danger_lut_tbl = {0x3ffff, 0x3ffff, 0x0},
	.safe_lut_tbl = {0xfe00, 0xfe00, 0xffff},
	.qos_lut_tbl = {
		{.nentry = ARRAY_SIZE(sc7180_qos_linear),
		.entries = sc7180_qos_linear
		},
		{.nentry = ARRAY_SIZE(sc7180_qos_macrotile),
		.entries = sc7180_qos_macrotile
		},
		{.nentry = ARRAY_SIZE(sc7180_qos_nrt),
		.entries = sc7180_qos_nrt
		},
		/* TODO: macrotile-qseed is different from macrotile */
	},
	.cdp_cfg = {
		{.rd_enable = 1, .wr_enable = 1},
		{.rd_enable = 1, .wr_enable = 0}
	},
	.clk_inefficiency_factor = 105,
	.bw_inefficiency_factor = 120,
};

static const struct dpu_mdss_version glymur_mdss_ver = {
	.core_major_ver = 12,
	.core_minor_ver = 2,
};

const struct dpu_mdss_cfg dpu_glymur_cfg = {
	.mdss_ver = &glymur_mdss_ver,
	.caps = &glymur_dpu_caps,
	.mdp = &glymur_mdp,
	.cdm = &dpu_cdm_5_x,
	.ctl_count = ARRAY_SIZE(glymur_ctl),
	.ctl = glymur_ctl,
	.sspp_count = ARRAY_SIZE(glymur_sspp),
	.sspp = glymur_sspp,
	.mixer_count = ARRAY_SIZE(glymur_lm),
	.mixer = glymur_lm,
	.dspp_count = ARRAY_SIZE(glymur_dspp),
	.dspp = glymur_dspp,
	.pingpong_count = ARRAY_SIZE(glymur_pp),
	.pingpong = glymur_pp,
	.dsc_count = ARRAY_SIZE(glymur_dsc),
	.dsc = glymur_dsc,
	.merge_3d_count = ARRAY_SIZE(glymur_merge_3d),
	.merge_3d = glymur_merge_3d,
	.wb_count = ARRAY_SIZE(glymur_wb),
	.wb = glymur_wb,
	.cwb_count = ARRAY_SIZE(glymur_cwb),
	.cwb = sm8650_cwb,
	.intf_count = ARRAY_SIZE(glymur_intf),
	.intf = glymur_intf,
	.vbif_count = ARRAY_SIZE(sm8650_vbif),
	.vbif = sm8650_vbif,
	.perf = &glymur_perf_data,
};

#endif
