(******************************************************************************)
(*                                                                            *)
(*                                  Monolith                                  *)
(*                                                                            *)
(*                              François Pottier                              *)
(*                                                                            *)
(*  Copyright Inria. All rights reserved. This file is distributed under the  *)
(*  terms of the GNU Lesser General Public License as published by the Free   *)
(*  Software Foundation, either version 3 of the License, or (at your         *)
(*  option) any later version, as described in the file LICENSE.              *)
(*                                                                            *)
(******************************************************************************)

(* See Monolith.mli for documentation. *)
type document = PPrint.document
type prologue = unit -> unit
type fuel = int
type failures = int

type settings = {

  source : string option;
    (**An optional file name. If this file name is present, then the engine
       runs in AFL mode and this file is used as a source of random bits.
       If it is absent, then the engine runs in random testing mode and
       /dev/urandom is used as a source of random bits. *)

  timeout : float option;
    (**An optional time limit, expressed in seconds. *)

  max_scenarios : int;
    (**In random testing mode, if [max_scenarios] failure scenarios are
       found, then testing stops. *)

  show_scenario : bool;
    (**This Boolean flag determines whether failure scenarios should be
       printed to the standard output channel. *)

  save_scenario : bool;
    (**This Boolean flag determines whether failure scenarios should be
       saved to a file in the directory [./output/crashes]. *)

  prologue : prologue;
    (**A prologue. *)

  fuel : fuel;
    (**The desired initial amount of fuel. *)

}

(* See Monolith.mli for documentation. *)
val main : ?prologue:prologue -> fuel -> unit
val run : settings -> failures

(* See Monolith.mli for documentation. *)
exception PleaseBackOff
exception Unimplemented
