/**
 * \file pappsomspp/amino_acid/chemicalformula.h
 * \date 06/04/2025
 * \author Olivier Langella
 * \brief simple object to hold chemical formula
 **/

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella
 *<Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#pragma once

#include "pappsomspp/core/amino_acid/atomnumberinterface.h"

namespace pappso
{
struct IsotopeCount
{
  const QString toString() const;
  Enums::Isotope isotope;
  std::int16_t count;
};

class ChemicalFormula : public AtomNumberInterface
{
  public:
  ChemicalFormula();
  ChemicalFormula(const AtomNumberInterface &atom_interface);
  ChemicalFormula(const ChemicalFormula &other);
  virtual ~ChemicalFormula();

  pappso::ChemicalFormula &operator=(const pappso::ChemicalFormula &other);

  pappso::ChemicalFormula operator-() const;
  pappso::ChemicalFormula operator+(const pappso::ChemicalFormula &to_add) const;

  int getNumberOfAtom(Enums::AtomIsotopeSurvey atom) const override;
  int getNumberOfIsotope(Enums::Isotope isotope) const override;

  double getMass() const;


  /** @brief get formula from an Obo term
   * */
  void setOboPsiModTerm(const OboPsiModTerm &term);

  /** @brief add an atom or isotope to the forumla
   */
  void addIsotopeCount(const IsotopeCount &isotope_count);

  const QString toString() const;

  /** @brief set full isotope labels
   */
  void setFullIsotope(Enums::Isotope isotope);

  private:
  void setPsimodDiffFormula(const QString &diff_formula);
  void setUnimodDiffFormula(const QString &diff_formula);
  void addIsotopeNumberCount(const QString &atom_str,
                             const QString &atom_isotope_number,
                             std::int8_t count);

  /** @brief simplify chemical formula
   * sort, group isotope, remove 0
   */
  void simplify();

  private:
  std::vector<IsotopeCount> m_isotopeVector;
};
} // namespace pappso
