"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeFonts = mergeFonts;
exports.consolidateFont = consolidateFont;
exports.consolidateGsubGpos = consolidateGsubGpos;
const ImpLib = require("@ot-builder/common-impl");
const Ot = require("@ot-builder/ot");
const Rectify = require("@ot-builder/rectify");
const design_unifier_1 = require("../../support/design-unifier");
const gsub_gpos_merger_1 = require("./gsub-gpos-merger");
const utils_1 = require("./utils");
function mergeFonts(basis, override, gsf, opt = {}) {
    (0, design_unifier_1.unifyDesignSpacesImpl)(new design_unifier_1.DesignUnifierSession(), basis, override);
    basis.glyphs = gsf.createStoreFromList([
        ...basis.glyphs.decideOrder(),
        ...override.glyphs.decideOrder()
    ]);
    mergeFontTables(basis, override, opt);
}
function consolidateFont(font) {
    const gs = new Set(font.glyphs.decideOrder());
    const rectifier = {
        glyphRef: g => (gs.has(g) ? g : null)
    };
    Rectify.inPlaceRectifyFontGlyphReferences(rectifier, font);
    if (font.gpos)
        font.gpos = consolidateGsubGpos(font.fvar, font.gpos);
    if (font.gsub)
        font.gsub = consolidateGsubGpos(font.fvar, font.gsub);
}
// TODO: Add CFF merging
function mergeFontTables(basis, override, opt) {
    if (opt.preferOverride) {
        basis.cmap = mergeCmap(override.cmap, basis.cmap);
        basis.gsub = mergeGsubGpos(override.fvar, override.gsub, basis.gsub, override.gdef, basis.gdef);
        basis.gpos = mergeGsubGpos(override.fvar, override.gpos, basis.gpos, override.gdef, basis.gdef);
        basis.gdef = mergeGdef(override.gdef, basis.gdef);
    }
    else {
        basis.cmap = mergeCmap(basis.cmap, override.cmap);
        basis.gsub = mergeGsubGpos(basis.fvar, basis.gsub, override.gsub, basis.gdef, override.gdef);
        basis.gpos = mergeGsubGpos(basis.fvar, basis.gpos, override.gpos, basis.gdef, override.gdef);
        basis.gdef = mergeGdef(basis.gdef, override.gdef);
    }
}
function mergeCmap(preferred, less) {
    if (!preferred)
        return less;
    if (!less)
        return preferred;
    for (const [u, g] of less.unicode.entries()) {
        if (!preferred.unicode.get(u))
            preferred.unicode.set(u, g);
    }
    for (const [u, s, g] of less.vs.entries()) {
        if (!preferred.vs.get(u, s))
            preferred.vs.set(u, s, g);
    }
    return preferred;
}
function mergeGdef(preferred, less) {
    if (!preferred)
        return less;
    if (!less)
        return preferred;
    const result = new Ot.Gdef.Table();
    result.glyphClassDef = (0, utils_1.mergeMapOpt)(preferred.glyphClassDef, less.glyphClassDef, utils_1.Prime);
    result.attachList = (0, utils_1.mergeMapOpt)(preferred.attachList, less.attachList, utils_1.Prime);
    result.ligCarets = (0, utils_1.mergeMapOpt)(preferred.ligCarets, less.ligCarets, utils_1.Prime);
    result.markAttachClassDef = (0, utils_1.mergeClassDefOpt)(preferred.markAttachClassDef, less.markAttachClassDef);
    result.markGlyphSets = (0, utils_1.combineList)(preferred.markGlyphSets, less.markGlyphSets);
    return result;
}
function mergeGsubGpos(fvar, preferred, less, preferredGdef, lessGdef) {
    if (!preferred)
        return less;
    if (!less)
        return preferred;
    const merger = new gsub_gpos_merger_1.GsubGposMerger(ImpLib.Order.fromList("Dimensions", fvar ? fvar.axes.map(a => a.dim) : []), preferred, less, preferredGdef, lessGdef);
    return merger.resolve();
}
function consolidateGsubGpos(fvar, preferred) {
    const merger = new gsub_gpos_merger_1.GsubGposMerger(ImpLib.Order.fromList("Dimensions", fvar ? fvar.axes.map(a => a.dim) : []), preferred, { scripts: new Map(), features: [], lookups: [], featureVariations: [] }, null, null);
    return merger.resolve();
}
//# sourceMappingURL=index.js.map