// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file mutableTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "mutableTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "mutable.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableShortStruct)
{

    ReturnCode_t return_code_MutableShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableShortStruct", type_ids_MutableShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableShortStruct)
    {
        StructTypeFlag struct_flags_MutableShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableShortStruct = "MutableShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableShortStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableShortStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableShortStruct;
        if (!tmp_ann_custom_MutableShortStruct.empty())
        {
            ann_custom_MutableShortStruct = tmp_ann_custom_MutableShortStruct;
        }

        CompleteTypeDetail detail_MutableShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableShortStruct, ann_custom_MutableShortStruct, type_name_MutableShortStruct.to_string());
        CompleteStructHeader header_MutableShortStruct;
        header_MutableShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableShortStruct);
        CompleteStructMemberSeq member_seq_MutableShortStruct;
        {
            TypeIdentifierPair type_ids_var_short;
            ReturnCode_t return_code_var_short {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_short);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_short)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_short Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_short = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_short = 0x00000000;
            bool common_var_short_ec {false};
            CommonStructMember common_var_short {TypeObjectUtils::build_common_struct_member(member_id_var_short, member_flags_var_short, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_short, common_var_short_ec))};
            if (!common_var_short_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_short member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_short = "var_short";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_short;
            ann_custom_MutableShortStruct.reset();
            CompleteMemberDetail detail_var_short = TypeObjectUtils::build_complete_member_detail(name_var_short, member_ann_builtin_var_short, ann_custom_MutableShortStruct);
            CompleteStructMember member_var_short = TypeObjectUtils::build_complete_struct_member(common_var_short, detail_var_short);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableShortStruct, member_var_short);
        }
        CompleteStructType struct_type_MutableShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableShortStruct, header_MutableShortStruct, member_seq_MutableShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableShortStruct, type_name_MutableShortStruct.to_string(), type_ids_MutableShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableUShortStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableUShortStruct)
{

    ReturnCode_t return_code_MutableUShortStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableUShortStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableUShortStruct", type_ids_MutableUShortStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableUShortStruct)
    {
        StructTypeFlag struct_flags_MutableUShortStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableUShortStruct = "MutableUShortStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableUShortStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableUShortStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableUShortStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableUShortStruct;
        if (!tmp_ann_custom_MutableUShortStruct.empty())
        {
            ann_custom_MutableUShortStruct = tmp_ann_custom_MutableUShortStruct;
        }

        CompleteTypeDetail detail_MutableUShortStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableUShortStruct, ann_custom_MutableUShortStruct, type_name_MutableUShortStruct.to_string());
        CompleteStructHeader header_MutableUShortStruct;
        header_MutableUShortStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableUShortStruct);
        CompleteStructMemberSeq member_seq_MutableUShortStruct;
        {
            TypeIdentifierPair type_ids_var_ushort;
            ReturnCode_t return_code_var_ushort {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_var_ushort);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ushort)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ushort Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ushort = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ushort = 0x00000000;
            bool common_var_ushort_ec {false};
            CommonStructMember common_var_ushort {TypeObjectUtils::build_common_struct_member(member_id_var_ushort, member_flags_var_ushort, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ushort, common_var_ushort_ec))};
            if (!common_var_ushort_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ushort member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ushort = "var_ushort";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ushort;
            ann_custom_MutableUShortStruct.reset();
            CompleteMemberDetail detail_var_ushort = TypeObjectUtils::build_complete_member_detail(name_var_ushort, member_ann_builtin_var_ushort, ann_custom_MutableUShortStruct);
            CompleteStructMember member_var_ushort = TypeObjectUtils::build_complete_struct_member(common_var_ushort, detail_var_ushort);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableUShortStruct, member_var_ushort);
        }
        CompleteStructType struct_type_MutableUShortStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableUShortStruct, header_MutableUShortStruct, member_seq_MutableUShortStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableUShortStruct, type_name_MutableUShortStruct.to_string(), type_ids_MutableUShortStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableUShortStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableLongStruct)
{

    ReturnCode_t return_code_MutableLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableLongStruct", type_ids_MutableLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableLongStruct)
    {
        StructTypeFlag struct_flags_MutableLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableLongStruct = "MutableLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableLongStruct;
        if (!tmp_ann_custom_MutableLongStruct.empty())
        {
            ann_custom_MutableLongStruct = tmp_ann_custom_MutableLongStruct;
        }

        CompleteTypeDetail detail_MutableLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableLongStruct, ann_custom_MutableLongStruct, type_name_MutableLongStruct.to_string());
        CompleteStructHeader header_MutableLongStruct;
        header_MutableLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableLongStruct);
        CompleteStructMemberSeq member_seq_MutableLongStruct;
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000000;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_MutableLongStruct.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_MutableLongStruct);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableLongStruct, member_var_long);
        }
        CompleteStructType struct_type_MutableLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableLongStruct, header_MutableLongStruct, member_seq_MutableLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableLongStruct, type_name_MutableLongStruct.to_string(), type_ids_MutableLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableULongStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableULongStruct)
{

    ReturnCode_t return_code_MutableULongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableULongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableULongStruct", type_ids_MutableULongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableULongStruct)
    {
        StructTypeFlag struct_flags_MutableULongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableULongStruct = "MutableULongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableULongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableULongStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableULongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableULongStruct;
        if (!tmp_ann_custom_MutableULongStruct.empty())
        {
            ann_custom_MutableULongStruct = tmp_ann_custom_MutableULongStruct;
        }

        CompleteTypeDetail detail_MutableULongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableULongStruct, ann_custom_MutableULongStruct, type_name_MutableULongStruct.to_string());
        CompleteStructHeader header_MutableULongStruct;
        header_MutableULongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableULongStruct);
        CompleteStructMemberSeq member_seq_MutableULongStruct;
        {
            TypeIdentifierPair type_ids_var_ulong;
            ReturnCode_t return_code_var_ulong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_var_ulong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulong = 0x00000000;
            bool common_var_ulong_ec {false};
            CommonStructMember common_var_ulong {TypeObjectUtils::build_common_struct_member(member_id_var_ulong, member_flags_var_ulong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulong, common_var_ulong_ec))};
            if (!common_var_ulong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulong = "var_ulong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulong;
            ann_custom_MutableULongStruct.reset();
            CompleteMemberDetail detail_var_ulong = TypeObjectUtils::build_complete_member_detail(name_var_ulong, member_ann_builtin_var_ulong, ann_custom_MutableULongStruct);
            CompleteStructMember member_var_ulong = TypeObjectUtils::build_complete_struct_member(common_var_ulong, detail_var_ulong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableULongStruct, member_var_ulong);
        }
        CompleteStructType struct_type_MutableULongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableULongStruct, header_MutableULongStruct, member_seq_MutableULongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableULongStruct, type_name_MutableULongStruct.to_string(), type_ids_MutableULongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableULongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableLongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableLongLongStruct)
{

    ReturnCode_t return_code_MutableLongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableLongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableLongLongStruct", type_ids_MutableLongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableLongLongStruct)
    {
        StructTypeFlag struct_flags_MutableLongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableLongLongStruct = "MutableLongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableLongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableLongLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableLongLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableLongLongStruct;
        if (!tmp_ann_custom_MutableLongLongStruct.empty())
        {
            ann_custom_MutableLongLongStruct = tmp_ann_custom_MutableLongLongStruct;
        }

        CompleteTypeDetail detail_MutableLongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableLongLongStruct, ann_custom_MutableLongLongStruct, type_name_MutableLongLongStruct.to_string());
        CompleteStructHeader header_MutableLongLongStruct;
        header_MutableLongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableLongLongStruct);
        CompleteStructMemberSeq member_seq_MutableLongLongStruct;
        {
            TypeIdentifierPair type_ids_var_longlong;
            ReturnCode_t return_code_var_longlong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_longlong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longlong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longlong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longlong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longlong = 0x00000000;
            bool common_var_longlong_ec {false};
            CommonStructMember common_var_longlong {TypeObjectUtils::build_common_struct_member(member_id_var_longlong, member_flags_var_longlong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longlong, common_var_longlong_ec))};
            if (!common_var_longlong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longlong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longlong = "var_longlong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longlong;
            ann_custom_MutableLongLongStruct.reset();
            CompleteMemberDetail detail_var_longlong = TypeObjectUtils::build_complete_member_detail(name_var_longlong, member_ann_builtin_var_longlong, ann_custom_MutableLongLongStruct);
            CompleteStructMember member_var_longlong = TypeObjectUtils::build_complete_struct_member(common_var_longlong, detail_var_longlong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableLongLongStruct, member_var_longlong);
        }
        CompleteStructType struct_type_MutableLongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableLongLongStruct, header_MutableLongLongStruct, member_seq_MutableLongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableLongLongStruct, type_name_MutableLongLongStruct.to_string(), type_ids_MutableLongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableLongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableULongLongStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableULongLongStruct)
{

    ReturnCode_t return_code_MutableULongLongStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableULongLongStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableULongLongStruct", type_ids_MutableULongLongStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableULongLongStruct)
    {
        StructTypeFlag struct_flags_MutableULongLongStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableULongLongStruct = "MutableULongLongStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableULongLongStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableULongLongStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableULongLongStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableULongLongStruct;
        if (!tmp_ann_custom_MutableULongLongStruct.empty())
        {
            ann_custom_MutableULongLongStruct = tmp_ann_custom_MutableULongLongStruct;
        }

        CompleteTypeDetail detail_MutableULongLongStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableULongLongStruct, ann_custom_MutableULongLongStruct, type_name_MutableULongLongStruct.to_string());
        CompleteStructHeader header_MutableULongLongStruct;
        header_MutableULongLongStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableULongLongStruct);
        CompleteStructMemberSeq member_seq_MutableULongLongStruct;
        {
            TypeIdentifierPair type_ids_var_ulonglong;
            ReturnCode_t return_code_var_ulonglong {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_ulonglong);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_ulonglong)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulonglong Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_ulonglong = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_ulonglong = 0x00000000;
            bool common_var_ulonglong_ec {false};
            CommonStructMember common_var_ulonglong {TypeObjectUtils::build_common_struct_member(member_id_var_ulonglong, member_flags_var_ulonglong, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_ulonglong, common_var_ulonglong_ec))};
            if (!common_var_ulonglong_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_ulonglong member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulonglong = "var_ulonglong";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_ulonglong;
            ann_custom_MutableULongLongStruct.reset();
            CompleteMemberDetail detail_var_ulonglong = TypeObjectUtils::build_complete_member_detail(name_var_ulonglong, member_ann_builtin_var_ulonglong, ann_custom_MutableULongLongStruct);
            CompleteStructMember member_var_ulonglong = TypeObjectUtils::build_complete_struct_member(common_var_ulonglong, detail_var_ulonglong);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableULongLongStruct, member_var_ulonglong);
        }
        CompleteStructType struct_type_MutableULongLongStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableULongLongStruct, header_MutableULongLongStruct, member_seq_MutableULongLongStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableULongLongStruct, type_name_MutableULongLongStruct.to_string(), type_ids_MutableULongLongStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableULongLongStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableFloatStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableFloatStruct)
{

    ReturnCode_t return_code_MutableFloatStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableFloatStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableFloatStruct", type_ids_MutableFloatStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableFloatStruct)
    {
        StructTypeFlag struct_flags_MutableFloatStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableFloatStruct = "MutableFloatStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableFloatStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableFloatStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableFloatStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableFloatStruct;
        if (!tmp_ann_custom_MutableFloatStruct.empty())
        {
            ann_custom_MutableFloatStruct = tmp_ann_custom_MutableFloatStruct;
        }

        CompleteTypeDetail detail_MutableFloatStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableFloatStruct, ann_custom_MutableFloatStruct, type_name_MutableFloatStruct.to_string());
        CompleteStructHeader header_MutableFloatStruct;
        header_MutableFloatStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableFloatStruct);
        CompleteStructMemberSeq member_seq_MutableFloatStruct;
        {
            TypeIdentifierPair type_ids_var_float;
            ReturnCode_t return_code_var_float {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_var_float);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_float)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_float Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_float = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_float = 0x00000000;
            bool common_var_float_ec {false};
            CommonStructMember common_var_float {TypeObjectUtils::build_common_struct_member(member_id_var_float, member_flags_var_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_float, common_var_float_ec))};
            if (!common_var_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_float = "var_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_float;
            ann_custom_MutableFloatStruct.reset();
            CompleteMemberDetail detail_var_float = TypeObjectUtils::build_complete_member_detail(name_var_float, member_ann_builtin_var_float, ann_custom_MutableFloatStruct);
            CompleteStructMember member_var_float = TypeObjectUtils::build_complete_struct_member(common_var_float, detail_var_float);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableFloatStruct, member_var_float);
        }
        CompleteStructType struct_type_MutableFloatStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableFloatStruct, header_MutableFloatStruct, member_seq_MutableFloatStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableFloatStruct, type_name_MutableFloatStruct.to_string(), type_ids_MutableFloatStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableFloatStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableDoubleStruct)
{

    ReturnCode_t return_code_MutableDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableDoubleStruct", type_ids_MutableDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableDoubleStruct)
    {
        StructTypeFlag struct_flags_MutableDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableDoubleStruct = "MutableDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableDoubleStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableDoubleStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableDoubleStruct;
        if (!tmp_ann_custom_MutableDoubleStruct.empty())
        {
            ann_custom_MutableDoubleStruct = tmp_ann_custom_MutableDoubleStruct;
        }

        CompleteTypeDetail detail_MutableDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableDoubleStruct, ann_custom_MutableDoubleStruct, type_name_MutableDoubleStruct.to_string());
        CompleteStructHeader header_MutableDoubleStruct;
        header_MutableDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableDoubleStruct);
        CompleteStructMemberSeq member_seq_MutableDoubleStruct;
        {
            TypeIdentifierPair type_ids_var_double;
            ReturnCode_t return_code_var_double {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_var_double);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_double)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_double Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_double = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_double = 0x00000000;
            bool common_var_double_ec {false};
            CommonStructMember common_var_double {TypeObjectUtils::build_common_struct_member(member_id_var_double, member_flags_var_double, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_double, common_var_double_ec))};
            if (!common_var_double_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_double member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_double = "var_double";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_double;
            ann_custom_MutableDoubleStruct.reset();
            CompleteMemberDetail detail_var_double = TypeObjectUtils::build_complete_member_detail(name_var_double, member_ann_builtin_var_double, ann_custom_MutableDoubleStruct);
            CompleteStructMember member_var_double = TypeObjectUtils::build_complete_struct_member(common_var_double, detail_var_double);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableDoubleStruct, member_var_double);
        }
        CompleteStructType struct_type_MutableDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableDoubleStruct, header_MutableDoubleStruct, member_seq_MutableDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableDoubleStruct, type_name_MutableDoubleStruct.to_string(), type_ids_MutableDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableLongDoubleStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableLongDoubleStruct)
{

    ReturnCode_t return_code_MutableLongDoubleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableLongDoubleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableLongDoubleStruct", type_ids_MutableLongDoubleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableLongDoubleStruct)
    {
        StructTypeFlag struct_flags_MutableLongDoubleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableLongDoubleStruct = "MutableLongDoubleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableLongDoubleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableLongDoubleStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableLongDoubleStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableLongDoubleStruct;
        if (!tmp_ann_custom_MutableLongDoubleStruct.empty())
        {
            ann_custom_MutableLongDoubleStruct = tmp_ann_custom_MutableLongDoubleStruct;
        }

        CompleteTypeDetail detail_MutableLongDoubleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableLongDoubleStruct, ann_custom_MutableLongDoubleStruct, type_name_MutableLongDoubleStruct.to_string());
        CompleteStructHeader header_MutableLongDoubleStruct;
        header_MutableLongDoubleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableLongDoubleStruct);
        CompleteStructMemberSeq member_seq_MutableLongDoubleStruct;
        {
            TypeIdentifierPair type_ids_var_longdouble;
            ReturnCode_t return_code_var_longdouble {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_longdouble =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_longdouble", type_ids_var_longdouble);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_longdouble)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longdouble Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_longdouble = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_longdouble = 0x00000000;
            bool common_var_longdouble_ec {false};
            CommonStructMember common_var_longdouble {TypeObjectUtils::build_common_struct_member(member_id_var_longdouble, member_flags_var_longdouble, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_longdouble, common_var_longdouble_ec))};
            if (!common_var_longdouble_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_longdouble member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longdouble = "var_longdouble";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_longdouble;
            ann_custom_MutableLongDoubleStruct.reset();
            CompleteMemberDetail detail_var_longdouble = TypeObjectUtils::build_complete_member_detail(name_var_longdouble, member_ann_builtin_var_longdouble, ann_custom_MutableLongDoubleStruct);
            CompleteStructMember member_var_longdouble = TypeObjectUtils::build_complete_struct_member(common_var_longdouble, detail_var_longdouble);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableLongDoubleStruct, member_var_longdouble);
        }
        CompleteStructType struct_type_MutableLongDoubleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableLongDoubleStruct, header_MutableLongDoubleStruct, member_seq_MutableLongDoubleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableLongDoubleStruct, type_name_MutableLongDoubleStruct.to_string(), type_ids_MutableLongDoubleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableLongDoubleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableBooleanStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableBooleanStruct)
{

    ReturnCode_t return_code_MutableBooleanStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableBooleanStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableBooleanStruct", type_ids_MutableBooleanStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableBooleanStruct)
    {
        StructTypeFlag struct_flags_MutableBooleanStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableBooleanStruct = "MutableBooleanStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableBooleanStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableBooleanStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableBooleanStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableBooleanStruct;
        if (!tmp_ann_custom_MutableBooleanStruct.empty())
        {
            ann_custom_MutableBooleanStruct = tmp_ann_custom_MutableBooleanStruct;
        }

        CompleteTypeDetail detail_MutableBooleanStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableBooleanStruct, ann_custom_MutableBooleanStruct, type_name_MutableBooleanStruct.to_string());
        CompleteStructHeader header_MutableBooleanStruct;
        header_MutableBooleanStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableBooleanStruct);
        CompleteStructMemberSeq member_seq_MutableBooleanStruct;
        {
            TypeIdentifierPair type_ids_var_boolean;
            ReturnCode_t return_code_var_boolean {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_var_boolean);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_boolean)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_boolean Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_boolean = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_boolean = 0x00000000;
            bool common_var_boolean_ec {false};
            CommonStructMember common_var_boolean {TypeObjectUtils::build_common_struct_member(member_id_var_boolean, member_flags_var_boolean, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_boolean, common_var_boolean_ec))};
            if (!common_var_boolean_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_boolean member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_boolean = "var_boolean";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_boolean;
            ann_custom_MutableBooleanStruct.reset();
            CompleteMemberDetail detail_var_boolean = TypeObjectUtils::build_complete_member_detail(name_var_boolean, member_ann_builtin_var_boolean, ann_custom_MutableBooleanStruct);
            CompleteStructMember member_var_boolean = TypeObjectUtils::build_complete_struct_member(common_var_boolean, detail_var_boolean);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableBooleanStruct, member_var_boolean);
        }
        CompleteStructType struct_type_MutableBooleanStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableBooleanStruct, header_MutableBooleanStruct, member_seq_MutableBooleanStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableBooleanStruct, type_name_MutableBooleanStruct.to_string(), type_ids_MutableBooleanStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableBooleanStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableOctetStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableOctetStruct)
{

    ReturnCode_t return_code_MutableOctetStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableOctetStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableOctetStruct", type_ids_MutableOctetStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableOctetStruct)
    {
        StructTypeFlag struct_flags_MutableOctetStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableOctetStruct = "MutableOctetStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableOctetStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableOctetStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableOctetStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableOctetStruct;
        if (!tmp_ann_custom_MutableOctetStruct.empty())
        {
            ann_custom_MutableOctetStruct = tmp_ann_custom_MutableOctetStruct;
        }

        CompleteTypeDetail detail_MutableOctetStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableOctetStruct, ann_custom_MutableOctetStruct, type_name_MutableOctetStruct.to_string());
        CompleteStructHeader header_MutableOctetStruct;
        header_MutableOctetStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableOctetStruct);
        CompleteStructMemberSeq member_seq_MutableOctetStruct;
        {
            TypeIdentifierPair type_ids_var_octet;
            ReturnCode_t return_code_var_octet {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_var_octet);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_octet)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_octet Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_octet = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_octet = 0x00000000;
            bool common_var_octet_ec {false};
            CommonStructMember common_var_octet {TypeObjectUtils::build_common_struct_member(member_id_var_octet, member_flags_var_octet, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_octet, common_var_octet_ec))};
            if (!common_var_octet_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_octet member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_octet = "var_octet";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_octet;
            ann_custom_MutableOctetStruct.reset();
            CompleteMemberDetail detail_var_octet = TypeObjectUtils::build_complete_member_detail(name_var_octet, member_ann_builtin_var_octet, ann_custom_MutableOctetStruct);
            CompleteStructMember member_var_octet = TypeObjectUtils::build_complete_struct_member(common_var_octet, detail_var_octet);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableOctetStruct, member_var_octet);
        }
        CompleteStructType struct_type_MutableOctetStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableOctetStruct, header_MutableOctetStruct, member_seq_MutableOctetStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableOctetStruct, type_name_MutableOctetStruct.to_string(), type_ids_MutableOctetStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableOctetStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableCharStruct)
{

    ReturnCode_t return_code_MutableCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableCharStruct", type_ids_MutableCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableCharStruct)
    {
        StructTypeFlag struct_flags_MutableCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableCharStruct = "MutableCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableCharStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableCharStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableCharStruct;
        if (!tmp_ann_custom_MutableCharStruct.empty())
        {
            ann_custom_MutableCharStruct = tmp_ann_custom_MutableCharStruct;
        }

        CompleteTypeDetail detail_MutableCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableCharStruct, ann_custom_MutableCharStruct, type_name_MutableCharStruct.to_string());
        CompleteStructHeader header_MutableCharStruct;
        header_MutableCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableCharStruct);
        CompleteStructMemberSeq member_seq_MutableCharStruct;
        {
            TypeIdentifierPair type_ids_var_char8;
            ReturnCode_t return_code_var_char8 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_var_char8);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char8)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char8 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char8 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char8 = 0x00000000;
            bool common_var_char8_ec {false};
            CommonStructMember common_var_char8 {TypeObjectUtils::build_common_struct_member(member_id_var_char8, member_flags_var_char8, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char8, common_var_char8_ec))};
            if (!common_var_char8_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char8 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char8 = "var_char8";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char8;
            ann_custom_MutableCharStruct.reset();
            CompleteMemberDetail detail_var_char8 = TypeObjectUtils::build_complete_member_detail(name_var_char8, member_ann_builtin_var_char8, ann_custom_MutableCharStruct);
            CompleteStructMember member_var_char8 = TypeObjectUtils::build_complete_struct_member(common_var_char8, detail_var_char8);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableCharStruct, member_var_char8);
        }
        CompleteStructType struct_type_MutableCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableCharStruct, header_MutableCharStruct, member_seq_MutableCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableCharStruct, type_name_MutableCharStruct.to_string(), type_ids_MutableCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableWCharStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableWCharStruct)
{

    ReturnCode_t return_code_MutableWCharStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableWCharStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableWCharStruct", type_ids_MutableWCharStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableWCharStruct)
    {
        StructTypeFlag struct_flags_MutableWCharStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableWCharStruct = "MutableWCharStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableWCharStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableWCharStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableWCharStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableWCharStruct;
        if (!tmp_ann_custom_MutableWCharStruct.empty())
        {
            ann_custom_MutableWCharStruct = tmp_ann_custom_MutableWCharStruct;
        }

        CompleteTypeDetail detail_MutableWCharStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableWCharStruct, ann_custom_MutableWCharStruct, type_name_MutableWCharStruct.to_string());
        CompleteStructHeader header_MutableWCharStruct;
        header_MutableWCharStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableWCharStruct);
        CompleteStructMemberSeq member_seq_MutableWCharStruct;
        {
            TypeIdentifierPair type_ids_var_char16;
            ReturnCode_t return_code_var_char16 {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_char16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_var_char16);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_char16)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char16 Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_char16 = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_char16 = 0x00000000;
            bool common_var_char16_ec {false};
            CommonStructMember common_var_char16 {TypeObjectUtils::build_common_struct_member(member_id_var_char16, member_flags_var_char16, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_char16, common_var_char16_ec))};
            if (!common_var_char16_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_char16 member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char16 = "var_char16";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_char16;
            ann_custom_MutableWCharStruct.reset();
            CompleteMemberDetail detail_var_char16 = TypeObjectUtils::build_complete_member_detail(name_var_char16, member_ann_builtin_var_char16, ann_custom_MutableWCharStruct);
            CompleteStructMember member_var_char16 = TypeObjectUtils::build_complete_struct_member(common_var_char16, detail_var_char16);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableWCharStruct, member_var_char16);
        }
        CompleteStructType struct_type_MutableWCharStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableWCharStruct, header_MutableWCharStruct, member_seq_MutableWCharStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableWCharStruct, type_name_MutableWCharStruct.to_string(), type_ids_MutableWCharStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableWCharStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableUnionStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableUnionStruct)
{

    ReturnCode_t return_code_MutableUnionStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableUnionStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableUnionStruct", type_ids_MutableUnionStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableUnionStruct)
    {
        StructTypeFlag struct_flags_MutableUnionStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableUnionStruct = "MutableUnionStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableUnionStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableUnionStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableUnionStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableUnionStruct;
        if (!tmp_ann_custom_MutableUnionStruct.empty())
        {
            ann_custom_MutableUnionStruct = tmp_ann_custom_MutableUnionStruct;
        }

        CompleteTypeDetail detail_MutableUnionStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableUnionStruct, ann_custom_MutableUnionStruct, type_name_MutableUnionStruct.to_string());
        CompleteStructHeader header_MutableUnionStruct;
        header_MutableUnionStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableUnionStruct);
        CompleteStructMemberSeq member_seq_MutableUnionStruct;
        {
            TypeIdentifierPair type_ids_var_union;
            ReturnCode_t return_code_var_union {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_union =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerUnionHelper", type_ids_var_union);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_union)
            {
            ::register_InnerUnionHelper_type_identifier(type_ids_var_union);
            }
            StructMemberFlag member_flags_var_union = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_union = 0x00000000;
            bool common_var_union_ec {false};
            CommonStructMember common_var_union {TypeObjectUtils::build_common_struct_member(member_id_var_union, member_flags_var_union, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_union, common_var_union_ec))};
            if (!common_var_union_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_union member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_union = "var_union";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_union;
            ann_custom_MutableUnionStruct.reset();
            CompleteMemberDetail detail_var_union = TypeObjectUtils::build_complete_member_detail(name_var_union, member_ann_builtin_var_union, ann_custom_MutableUnionStruct);
            CompleteStructMember member_var_union = TypeObjectUtils::build_complete_struct_member(common_var_union, detail_var_union);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableUnionStruct, member_var_union);
        }
        CompleteStructType struct_type_MutableUnionStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableUnionStruct, header_MutableUnionStruct, member_seq_MutableUnionStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableUnionStruct, type_name_MutableUnionStruct.to_string(), type_ids_MutableUnionStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableUnionStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableEmptyStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableEmptyStruct)
{

    ReturnCode_t return_code_MutableEmptyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableEmptyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableEmptyStruct", type_ids_MutableEmptyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableEmptyStruct)
    {
        StructTypeFlag struct_flags_MutableEmptyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        QualifiedTypeName type_name_MutableEmptyStruct = "MutableEmptyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableEmptyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableEmptyStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableEmptyStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableEmptyStruct;
        if (!tmp_ann_custom_MutableEmptyStruct.empty())
        {
            ann_custom_MutableEmptyStruct = tmp_ann_custom_MutableEmptyStruct;
        }

        CompleteTypeDetail detail_MutableEmptyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableEmptyStruct, ann_custom_MutableEmptyStruct, type_name_MutableEmptyStruct.to_string());
        CompleteStructHeader header_MutableEmptyStruct;
        header_MutableEmptyStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_MutableEmptyStruct);
        CompleteStructMemberSeq member_seq_MutableEmptyStruct;
        CompleteStructType struct_type_MutableEmptyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableEmptyStruct, header_MutableEmptyStruct, member_seq_MutableEmptyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableEmptyStruct, type_name_MutableEmptyStruct.to_string(), type_ids_MutableEmptyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableEmptyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableEmptyInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableEmptyInheritanceStruct)
{

    ReturnCode_t return_code_MutableEmptyInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableEmptyInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableEmptyInheritanceStruct", type_ids_MutableEmptyInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableEmptyInheritanceStruct)
    {
        StructTypeFlag struct_flags_MutableEmptyInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        return_code_MutableEmptyInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "MutableEmptyStruct", type_ids_MutableEmptyInheritanceStruct);

        if (return_code_MutableEmptyInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_MutableEmptyStruct_type_identifier(type_ids_MutableEmptyInheritanceStruct);
        }
        QualifiedTypeName type_name_MutableEmptyInheritanceStruct = "MutableEmptyInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableEmptyInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableEmptyInheritanceStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableEmptyInheritanceStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableEmptyInheritanceStruct;
        if (!tmp_ann_custom_MutableEmptyInheritanceStruct.empty())
        {
            ann_custom_MutableEmptyInheritanceStruct = tmp_ann_custom_MutableEmptyInheritanceStruct;
        }

        CompleteTypeDetail detail_MutableEmptyInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableEmptyInheritanceStruct, ann_custom_MutableEmptyInheritanceStruct, type_name_MutableEmptyInheritanceStruct.to_string());
        CompleteStructHeader header_MutableEmptyInheritanceStruct;
        if (EK_COMPLETE == type_ids_MutableEmptyInheritanceStruct.type_identifier1()._d())
        {
            header_MutableEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_MutableEmptyInheritanceStruct.type_identifier1(), detail_MutableEmptyInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_MutableEmptyInheritanceStruct.type_identifier2()._d())
        {
            header_MutableEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_MutableEmptyInheritanceStruct.type_identifier2(), detail_MutableEmptyInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableEmptyInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_MutableEmptyInheritanceStruct;
        {
            TypeIdentifierPair type_ids_var_str;
            ReturnCode_t return_code_var_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_str = 0x00000000;
            bool common_var_str_ec {false};
            CommonStructMember common_var_str {TypeObjectUtils::build_common_struct_member(member_id_var_str, member_flags_var_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_str, common_var_str_ec))};
            if (!common_var_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_str = "var_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_str;
            ann_custom_MutableEmptyInheritanceStruct.reset();
            CompleteMemberDetail detail_var_str = TypeObjectUtils::build_complete_member_detail(name_var_str, member_ann_builtin_var_str, ann_custom_MutableEmptyInheritanceStruct);
            CompleteStructMember member_var_str = TypeObjectUtils::build_complete_struct_member(common_var_str, detail_var_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableEmptyInheritanceStruct, member_var_str);
        }
        CompleteStructType struct_type_MutableEmptyInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableEmptyInheritanceStruct, header_MutableEmptyInheritanceStruct, member_seq_MutableEmptyInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableEmptyInheritanceStruct, type_name_MutableEmptyInheritanceStruct.to_string(), type_ids_MutableEmptyInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableEmptyInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableInheritanceStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableInheritanceStruct)
{

    ReturnCode_t return_code_MutableInheritanceStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableInheritanceStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableInheritanceStruct", type_ids_MutableInheritanceStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableInheritanceStruct)
    {
        StructTypeFlag struct_flags_MutableInheritanceStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        return_code_MutableInheritanceStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "MutableShortStruct", type_ids_MutableInheritanceStruct);

        if (return_code_MutableInheritanceStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_MutableShortStruct_type_identifier(type_ids_MutableInheritanceStruct);
        }
        QualifiedTypeName type_name_MutableInheritanceStruct = "MutableInheritanceStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableInheritanceStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableInheritanceStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableInheritanceStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableInheritanceStruct;
        if (!tmp_ann_custom_MutableInheritanceStruct.empty())
        {
            ann_custom_MutableInheritanceStruct = tmp_ann_custom_MutableInheritanceStruct;
        }

        CompleteTypeDetail detail_MutableInheritanceStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableInheritanceStruct, ann_custom_MutableInheritanceStruct, type_name_MutableInheritanceStruct.to_string());
        CompleteStructHeader header_MutableInheritanceStruct;
        if (EK_COMPLETE == type_ids_MutableInheritanceStruct.type_identifier1()._d())
        {
            header_MutableInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_MutableInheritanceStruct.type_identifier1(), detail_MutableInheritanceStruct);
        }
        else if (EK_COMPLETE == type_ids_MutableInheritanceStruct.type_identifier2()._d())
        {
            header_MutableInheritanceStruct = TypeObjectUtils::build_complete_struct_header(type_ids_MutableInheritanceStruct.type_identifier2(), detail_MutableInheritanceStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableInheritanceStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_MutableInheritanceStruct;
        {
            TypeIdentifierPair type_ids_var_str;
            ReturnCode_t return_code_var_str {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_str =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_str);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_str)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_str))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_var_str = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_str = 0x00000001;
            bool common_var_str_ec {false};
            CommonStructMember common_var_str {TypeObjectUtils::build_common_struct_member(member_id_var_str, member_flags_var_str, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_str, common_var_str_ec))};
            if (!common_var_str_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_str member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_str = "var_str";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_str;
            ann_custom_MutableInheritanceStruct.reset();
            CompleteMemberDetail detail_var_str = TypeObjectUtils::build_complete_member_detail(name_var_str, member_ann_builtin_var_str, ann_custom_MutableInheritanceStruct);
            CompleteStructMember member_var_str = TypeObjectUtils::build_complete_struct_member(common_var_str, detail_var_str);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableInheritanceStruct, member_var_str);
        }
        CompleteStructType struct_type_MutableInheritanceStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableInheritanceStruct, header_MutableInheritanceStruct, member_seq_MutableInheritanceStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableInheritanceStruct, type_name_MutableInheritanceStruct.to_string(), type_ids_MutableInheritanceStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableInheritanceStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableInheritanceEmptyStruct_type_identifier(
        TypeIdentifierPair& type_ids_MutableInheritanceEmptyStruct)
{

    ReturnCode_t return_code_MutableInheritanceEmptyStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableInheritanceEmptyStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableInheritanceEmptyStruct", type_ids_MutableInheritanceEmptyStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableInheritanceEmptyStruct)
    {
        StructTypeFlag struct_flags_MutableInheritanceEmptyStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        return_code_MutableInheritanceEmptyStruct =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "MutableShortStruct", type_ids_MutableInheritanceEmptyStruct);

        if (return_code_MutableInheritanceEmptyStruct != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_MutableShortStruct_type_identifier(type_ids_MutableInheritanceEmptyStruct);
        }
        QualifiedTypeName type_name_MutableInheritanceEmptyStruct = "MutableInheritanceEmptyStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableInheritanceEmptyStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableInheritanceEmptyStruct;
        AppliedAnnotationSeq tmp_ann_custom_MutableInheritanceEmptyStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_MutableInheritanceEmptyStruct;
        if (!tmp_ann_custom_MutableInheritanceEmptyStruct.empty())
        {
            ann_custom_MutableInheritanceEmptyStruct = tmp_ann_custom_MutableInheritanceEmptyStruct;
        }

        CompleteTypeDetail detail_MutableInheritanceEmptyStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableInheritanceEmptyStruct, ann_custom_MutableInheritanceEmptyStruct, type_name_MutableInheritanceEmptyStruct.to_string());
        CompleteStructHeader header_MutableInheritanceEmptyStruct;
        if (EK_COMPLETE == type_ids_MutableInheritanceEmptyStruct.type_identifier1()._d())
        {
            header_MutableInheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_header(type_ids_MutableInheritanceEmptyStruct.type_identifier1(), detail_MutableInheritanceEmptyStruct);
        }
        else if (EK_COMPLETE == type_ids_MutableInheritanceEmptyStruct.type_identifier2()._d())
        {
            header_MutableInheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_header(type_ids_MutableInheritanceEmptyStruct.type_identifier2(), detail_MutableInheritanceEmptyStruct);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableInheritanceEmptyStruct Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_MutableInheritanceEmptyStruct;
        CompleteStructType struct_type_MutableInheritanceEmptyStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableInheritanceEmptyStruct, header_MutableInheritanceEmptyStruct, member_seq_MutableInheritanceEmptyStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableInheritanceEmptyStruct, type_name_MutableInheritanceEmptyStruct.to_string(), type_ids_MutableInheritanceEmptyStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableInheritanceEmptyStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_MutableExtensibilityInheritance_type_identifier(
        TypeIdentifierPair& type_ids_MutableExtensibilityInheritance)
{

    ReturnCode_t return_code_MutableExtensibilityInheritance {eprosima::fastdds::dds::RETCODE_OK};
    return_code_MutableExtensibilityInheritance =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "MutableExtensibilityInheritance", type_ids_MutableExtensibilityInheritance);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_MutableExtensibilityInheritance)
    {
        StructTypeFlag struct_flags_MutableExtensibilityInheritance = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::MUTABLE,
                false, false);
        return_code_MutableExtensibilityInheritance =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "MutableShortStruct", type_ids_MutableExtensibilityInheritance);

        if (return_code_MutableExtensibilityInheritance != eprosima::fastdds::dds::RETCODE_OK)
        {
::register_MutableShortStruct_type_identifier(type_ids_MutableExtensibilityInheritance);
        }
        QualifiedTypeName type_name_MutableExtensibilityInheritance = "MutableExtensibilityInheritance";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_MutableExtensibilityInheritance;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_MutableExtensibilityInheritance;
        CompleteTypeDetail detail_MutableExtensibilityInheritance = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_MutableExtensibilityInheritance, ann_custom_MutableExtensibilityInheritance, type_name_MutableExtensibilityInheritance.to_string());
        CompleteStructHeader header_MutableExtensibilityInheritance;
        if (EK_COMPLETE == type_ids_MutableExtensibilityInheritance.type_identifier1()._d())
        {
            header_MutableExtensibilityInheritance = TypeObjectUtils::build_complete_struct_header(type_ids_MutableExtensibilityInheritance.type_identifier1(), detail_MutableExtensibilityInheritance);
        }
        else if (EK_COMPLETE == type_ids_MutableExtensibilityInheritance.type_identifier2()._d())
        {
            header_MutableExtensibilityInheritance = TypeObjectUtils::build_complete_struct_header(type_ids_MutableExtensibilityInheritance.type_identifier2(), detail_MutableExtensibilityInheritance);
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableExtensibilityInheritance Structure: base_type TypeIdentifier registered in TypeObjectRegistry is inconsistent.");
            return;
        }
        CompleteStructMemberSeq member_seq_MutableExtensibilityInheritance;
        {
            TypeIdentifierPair type_ids_var_long;
            ReturnCode_t return_code_var_long {eprosima::fastdds::dds::RETCODE_OK};
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_var_long)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_var_long = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_var_long = 0x00000001;
            bool common_var_long_ec {false};
            CommonStructMember common_var_long {TypeObjectUtils::build_common_struct_member(member_id_var_long, member_flags_var_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_var_long, common_var_long_ec))};
            if (!common_var_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure var_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_var_long;
            ann_custom_MutableExtensibilityInheritance.reset();
            CompleteMemberDetail detail_var_long = TypeObjectUtils::build_complete_member_detail(name_var_long, member_ann_builtin_var_long, ann_custom_MutableExtensibilityInheritance);
            CompleteStructMember member_var_long = TypeObjectUtils::build_complete_struct_member(common_var_long, detail_var_long);
            TypeObjectUtils::add_complete_struct_member(member_seq_MutableExtensibilityInheritance, member_var_long);
        }
        CompleteStructType struct_type_MutableExtensibilityInheritance = TypeObjectUtils::build_complete_struct_type(struct_flags_MutableExtensibilityInheritance, header_MutableExtensibilityInheritance, member_seq_MutableExtensibilityInheritance);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_MutableExtensibilityInheritance, type_name_MutableExtensibilityInheritance.to_string(), type_ids_MutableExtensibilityInheritance))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "MutableExtensibilityInheritance already registered in TypeObjectRegistry for a different type.");
        }
    }
}
